/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.nat;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Server {
    public static final String SERVER_HOST = "peers.sourceforge.net";
    public static final String PREFIX = "/peers";
    private InetAddress remoteAddress = InetAddress.getByName("peers.sourceforge.net");
    private int remotePort = 80;
    private Socket socket;

    public Server(InetAddress localAddress, int localPort) throws IOException {
        this.socket = new Socket(this.remoteAddress, this.remotePort, localAddress, localPort);
    }

    public void update(String email) {
        String encodedEmail;
        try {
            encodedEmail = URLEncoder.encode(email, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return;
        }
        StringBuffer urlEnd = new StringBuffer();
        urlEnd.append("update2.php?email=");
        urlEnd.append(encodedEmail);
        this.get(urlEnd.toString());
        this.close();
    }

    public Document getPeers(String email) {
        DocumentBuilder documentBuilder;
        URL url;
        String encodedEmail;
        try {
            encodedEmail = URLEncoder.encode(email, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        StringBuffer urlBuf = new StringBuffer();
        urlBuf.append("http://");
        urlBuf.append(SERVER_HOST);
        urlBuf.append(PREFIX);
        urlBuf.append("/getassocasxml.php?email=");
        urlBuf.append(encodedEmail);
        try {
            url = new URL(urlBuf.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        System.out.println("retrieved peers");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        try {
            URLConnection urlConnection = url.openConnection();
            InputStream inputStream = urlConnection.getInputStream();
            return documentBuilder.parse(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String get(String urlEnd) {
        StringBuffer get = new StringBuffer();
        get.append("GET ");
        get.append(PREFIX);
        get.append('/');
        get.append(urlEnd);
        get.append(" HTTP/1.1\r\n");
        get.append("Host: ");
        get.append(SERVER_HOST);
        get.append("\r\n");
        get.append("\r\n");
        try {
            this.socket.getOutputStream().write(get.toString().getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        System.out.println("> sent:\n" + get.toString());
        StringBuffer result = new StringBuffer();
        try {
            byte[] buf = new byte[256];
            int read = 0;
            while ((read = this.socket.getInputStream().read(buf)) > -1) {
                byte[] exactBuf = new byte[read];
                System.arraycopy(buf, 0, exactBuf, 0, read);
                result.append(new String(exactBuf));
            }
        }
        catch (SocketTimeoutException e) {
            System.out.println("socket timeout");
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        System.out.println("< received:\n" + result.toString());
        return result.toString();
    }

    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

